/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;

import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/**
 *  Dao̊{@\񋟂B<br><br>
 *  Statement擾SQLsADB֘A\bhLB<br>
 */
public abstract class BaseDao {
	
	// 萔
	/**
	 * ftHg(쐬)B<br>
	 * {@link #setCommonParams(boolean)}A
	 * {@link #mappingCommonInfo(BaseDto)}ŗpB<br>
	 * svȏꍇ́A""(󕶎)ݒ肷B
	 */
	protected String INSERT_DATE = "adddt";
	
	/**
	 * ftHg(쐬)B<br>
	 * {@link #setCommonParams(boolean)}A
	 * {@link #mappingCommonInfo(BaseDto)}ŗpB<br>
	 * svȏꍇ́A""(󕶎)ݒ肷B
	 */
	protected String INSERT_USER = "addcd";
	
	/**
	 * ftHg(XV)B<br>
	 * {@link #setCommonParams(boolean)}A
	 * {@link #mappingCommonInfo(BaseDto)}ŗpB<br>
	 * svȏꍇ́A""(󕶎)ݒ肷B
	 */
	protected String UPDATE_DATE = "upddt";
	
	/**
	 * ftHg(XV)B<br>
	 * {@link #setCommonParams(boolean)}A
	 * {@link #mappingCommonInfo(BaseDto)}ŗpB<br>
	 * svȏꍇ́A""(󕶎)ݒ肷B
	 */
	protected String UPDATE_USER = "updcd";
	
	// tB[h
	/**
	 * MosPAvP[Vݒ(/WEB-INF/mosp.properties)B<br>
	 */
	protected Properties        cfg;
	
	/**
	 * OCASP[U[IDB<br>
	 */
	protected String            aspUserId;
	
	/**
	 * OC[U[IDB<br>
	 */
	protected String            userId;
	
	/**
	 * CommandB<br>
	 */
	protected String            cmd;
	
	
	/**
	 * DBRlNVB<br>
	 */
	protected Connection        conn;
	
	/**
	 * eSQLs̍ۂɗpXe[ggB<br>
	 */
	protected PreparedStatement ps;
	
	/**
	 * e팟SQLsʁB<br>
	 */
	protected ResultSet         rs;
	
	/**
	 * eXVSQLsB<br>
	 */
	protected int               cnt;
	
	/**
	 * p[^[CfbNXB<br>
	 */
	protected int index;
	
	// Op
	String       sql;
	StringBuffer params;

	/**
	 * RXgN^B<br>
	 */
	protected BaseDao(){
		/*  */
	}
	
	/**
	 * RXgN^B<br>
	 * {@link #initDao(Properties, String, CmAspUserDto, CmUserDto, Connection)}
	 * ŏB
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	protected BaseDao(
			Properties   cfg,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user,
			Connection   conn
	){
		initDao(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * DAOB<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public void initDao(
			Properties   cfg,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user,
			Connection   conn
	) {
		this.cfg = cfg;
		this.cmd = cmd;
		if (aspUser != null) {
			this.aspUserId = aspUser.getAspUserId();
		}
		if (user != null) {
			this.userId = user.getUserId();
		}
		this.conn = conn;
		params = new StringBuffer();
	}
	
	
	/**
	 * ResultSetJB<br>
	 * @throws SQLException
	 */
	protected void releaseResultSet() throws SQLException {
		if (rs != null) {
			rs.close();
		}
	}
	
	/**
	 * PreparedStatement擾B<br>
	 * @param sql sSQL
	 * @throws SQLException
	 */
	protected void prepareStatement(String sql) throws SQLException {
		ps = conn.prepareStatement(sql);
		this.sql = sql;
	}

	
	/**
	 * PreparedStatementJB<br>
	 * @throws SQLException
	 */
	protected void releasePreparedStatement() throws SQLException {
		if (ps != null) {
			ps.close();
		}
		this.sql = "";
	}
	
	
	/**
	 * p[^ݒ(String)B<br>
	 * @param idx CfbNX
	 * @param param p[^
	 * @throws SQLException
	 */
	protected void setParam(int idx, String param) throws SQLException {
		if (ps != null) {
			ps.setString(idx, param);
			params.append(param);
			params.append(MospConst.DATA_SEPARATOR);
		}
	}
	
	/**
	 * p[^ݒ(int)B<br>
	 * @param idx CfbNX
	 * @param param p[^
	 * @throws SQLException
	 */
	protected void setParam(int idx, int param) throws SQLException {
		if (ps != null) {
			ps.setInt(idx, param);
			params.append(param);
			params.append(MospConst.DATA_SEPARATOR);
		}
	}
	
	/**
	 * p[^ݒ(long)B<br>
	 * @param idx CfbNX
	 * @param param p[^
	 * @throws SQLException
	 */
	protected void setParam(int idx, long param) throws SQLException {
		if (ps != null) {
			ps.setLong(idx, param);
			params.append(param);
			params.append(MospConst.DATA_SEPARATOR);
		}
	}
	
	/**
	 * p[^ݒ(float)B<br>
	 * @param idx CfbNX
	 * @param param p[^
	 * @throws SQLException
	 */
	protected void setParam(int idx, float param) throws SQLException {
		if (ps != null) {
			ps.setFloat(idx, param);
			params.append(param);
			params.append(MospConst.DATA_SEPARATOR);
		}
	}
	
	/**
	 * p[^ݒ(double)B<br>
	 * @param idx CfbNX
	 * @param param p[^
	 * @throws SQLException
	 */
	protected void setParam(int idx, double param) throws SQLException {
		if (ps != null) {
			ps.setDouble(idx, param);
			params.append(param);
			params.append(MospConst.DATA_SEPARATOR);
		}
	}
	
	
	/**
	 * p[^ݒ(Date)B<br>
	 * java.sql.TimestampƂĐݒ肷B<br>
	 * @param idx CfbNX
	 * @param param p[^
	 * @throws SQLException
	 */
	protected void setParam(int idx, Date param) throws SQLException {
		if (ps != null) {
			if (param == null) {
				ps.setTimestamp(idx, null);
			} else {
				ps.setTimestamp(idx, new Timestamp(param.getTime()));
			}
			params.append(param);
			params.append(MospConst.DATA_SEPARATOR);
		}
	}
	
	/**
	 * p[^ݒ(Date)B<br>
	 * java.sql.Date(N)ƂĐݒ肷B<br>
	 * @param idx CfbNX
	 * @param param p[^
	 * @throws SQLException
	 */
	protected void setDateParam(int idx, Date param) throws SQLException {
		if (ps != null) {
			if (param == null) {
				ps.setDate(idx, null);
			} else {
				ps.setDate(idx, new java.sql.Date(param.getTime()));
			}
			params.append(param);
			params.append(MospConst.DATA_SEPARATOR);
		}
	}
	
	/**
	 * p[^B<br>
	 * @throws SQLException
	 */
	protected void clearParams() throws SQLException {
		if (ps != null) {
			ps.clearParameters();
		}
		params = new StringBuffer();
	}
	
	
	/**
	 * nSQLsB<br>
	 * @throws SQLException
	 */
	protected void executeQuery() throws SQLException {
		if (ps != null) {
			rs = ps.executeQuery();
		}
	}
	
	
	/**
	 * XVnSQLsB<br>
	 * @throws SQLException
	 */
	protected void executeUpdate() throws SQLException {
		if (ps != null) {
			cnt = ps.executeUpdate();
			LogUtility.log(cfg, aspUserId, userId, cmd, 2, MospConst.LOG_EXECUTE, params.toString() + sql);
		}
	}
	
	
	/**
	 * XVnSQLs(Oo͐t)B<br>
	 * @param needLog Oo͗v
	 * @throws SQLException
	 */
	protected void executeUpdate(boolean needLog) throws SQLException {
		if (ps != null) {
			cnt = ps.executeUpdate();
			if (needLog) {
				LogUtility.log(cfg, aspUserId, userId, cmd, 2, MospConst.LOG_EXECUTE, params.toString() + sql);
			}
		}
	}
	
	
	/**
	 * SSQL擾B<br>
	 * @param cls DaoNX
	 * @return SSQL
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String getSelectQuery(Class<?> cls) throws NoSuchFieldException, IllegalAccessException {
		StringBuffer query = new StringBuffer();
		query.append(getSelectStatement(cls));
		query.append("FROM ");
		query.append(getTable(cls));
		query.append(" ");
		return query.toString();
	}
	
	/**
	 * SQL擾B<br>
	 * @param cls DaoNX
	 * @return SSQL
	 * @throws IllegalAccessException
	 */
	protected String getSelectStatement(Class<?> cls) throws IllegalAccessException {
		StringBuffer query = new StringBuffer();
		query.append("SELECT ");
		Field[] fields = cls.getFields();
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String name = field.getName();
			if (name.indexOf("COL_") == 0) {
				query.append(field.get(null));
				query.append(", ");
			}
		}
		query.append(getCommonColumn());
		query.delete(query.length() - 2, query.length() - 1);
		return query.toString();
	}
	
	/**
	 * SQL擾B<br>
	 * @param cls DaoNX
	 * @return SSQL
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	protected String getSelectStatement(
			Class<?> cls, boolean needTableName
	) throws IllegalAccessException, NoSuchFieldException {
		StringBuffer query = new StringBuffer();
		query.append("SELECT ");
		Field[] fields = cls.getFields();
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String name = field.getName();
			if (name.indexOf("COL_") == 0) {
				if (needTableName) {
					query.append(getTable(cls) + ".");
				}
				query.append(field.get(null));
				query.append(", ");
			}
		}
		query.append(getCommonColumn(cls, needTableName));
		query.delete(query.length() - 2, query.length() - 1);
		return query.toString();
	}
	
	/**
	 * SQL擾B<br>
	 * @param cls DaoNX
	 * @return SSQL
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	protected String getSelectCountQuery(
			Class<?> cls
	) throws IllegalAccessException, NoSuchFieldException {
		StringBuffer query = new StringBuffer();
		query.append(getSelectCountStatement());
		query.append(" FROM ");
		query.append(getTable(cls));
		query.append(" ");
		return query.toString();
	}
	
	/**
	 * SQL擾B<br>
	 * @return SQL(SELECT COUNT(*))
	 */
	protected String getSelectCountStatement() {
		StringBuffer query = new StringBuffer();
		query.append("SELECT COUNT(*) ");
		return query.toString();
	}
	
	/**
	 * }SQL擾B<br>
	 * @param cls dtoNX
	 * @return }SQL
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String getInsertQuery(
			Class<?> cls
	) throws NoSuchFieldException, IllegalAccessException {
		StringBuffer query = new StringBuffer();
		query.append(getInsertQueryBase(cls));
		query.append("(");
		Field[] fields = getClass().getFields();
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String name = field.getName();
			if (name.indexOf("COL_") == 0) {
				query.append("?, ");
			}
		}
		query.append(getCommonParams());
		query.delete(query.length() - 2, query.length());
		query.append(")");
		return query.toString();
	}
	
	/**
	 * }SQL̃x[X擾B<br>
	 * @param cls dtoNX
	 * @return }SQLx[X
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	private String getInsertQueryBase(
			Class<?> cls
	) throws IllegalAccessException, NoSuchFieldException {
		StringBuffer query = new StringBuffer();
		query.append("INSERT INTO ");
		query.append(getTable(cls));
		query.append("(");
		Field[] fields = getClass().getFields();
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String name = field.getName();
			if (name.indexOf("COL_") == 0) {
				query.append(field.get(null));
				query.append(", ");
			}
		}
		query.append(getCommonColumn());
		query.delete(query.length() - 2, query.length() - 1);
		query.append(") VALUES");
		return query.toString();
	}

	/**
	 * {@link #INSERT_USER}A{@link #INSERT_DATE}A
	 * {@link #UPDATE_USER}A{@link #UPDATE_DATE}
	 * SQL擾B<br>
	 * @return 쐬ҁA쐬AXVҁAXVSQL
	 */
	private String getCommonColumn() {
		StringBuffer query = new StringBuffer();
		if (!INSERT_DATE.equals("")) {
			query.append(INSERT_DATE + ", ");
		}
		if (!INSERT_USER.equals("")) {
			query.append(INSERT_USER + ", ");
		}
		if (!UPDATE_DATE.equals("")) {
			query.append(UPDATE_DATE + ", ");
		}
		if (!UPDATE_USER.equals("")) {
			query.append(UPDATE_USER + ", ");
		}
		return query.toString();
	}
	
	/**
	 * {@link #INSERT_USER}A{@link #INSERT_DATE}A
	 * {@link #UPDATE_USER}A{@link #UPDATE_DATE}
	 * SQL擾B<br>
	 * @return 쐬ҁA쐬AXVҁAXVSQL
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	private String getCommonColumn(
			Class<?> cls, boolean needTableName
	) throws NoSuchFieldException, IllegalAccessException {
		StringBuffer query = new StringBuffer();
		if (!INSERT_DATE.equals("")) {
			if (needTableName) {
				query.append(getTable(cls) + ".");
			}
			query.append(INSERT_DATE + ", ");
		}
		if (!INSERT_USER.equals("")) {
			if (needTableName) {
				query.append(getTable(cls) + ".");
			}
			query.append(INSERT_USER + ", ");
		}
		if (!UPDATE_DATE.equals("")) {
			if (needTableName) {
				query.append(getTable(cls) + ".");
			}
			query.append(UPDATE_DATE + ", ");
		}
		if (!UPDATE_USER.equals("")) {
			if (needTableName) {
				query.append(getTable(cls) + ".");
			}
			query.append(UPDATE_USER + ", ");
		}
		return query.toString();
	}
	
	/**
	 * {@link #INSERT_USER}A{@link #INSERT_DATE}A
	 * {@link #UPDATE_USER}A{@link #UPDATE_DATE}
	 * ̃p[^ݒSQL擾B<br>
	 * @return 쐬ҁA쐬AXVҁAXVp[^ݒSQL
	 */
	private String getCommonParams() {
		StringBuffer query = new StringBuffer();
		if (!INSERT_DATE.equals("")) {
			query.append("?, ");
		}
		if (!INSERT_USER.equals("")) {
			query.append("?, ");
		}
		if (!UPDATE_DATE.equals("")) {
			query.append("?, ");
		}
		if (!UPDATE_USER.equals("")) {
			query.append("?, ");
		}
		return query.toString();
	}
	
	/**
	 * XVSQL擾B<br>
	 * @param cls dtoNX
	 * @return XVSQL
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String getUpdateQuery(
			Class<?> cls
	) throws NoSuchFieldException, IllegalAccessException {
		StringBuffer query = new StringBuffer();
		query.append("UPDATE ");
		query.append(getTable(cls));
		query.append(" SET ");
		Field[] fields = cls.getFields();
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String name = field.getName();
			if (name.indexOf("COL_") == 0) {
				query.append(field.get(null));
				query.append(" = ?, ");
			}
		}
		if (!UPDATE_DATE.equals("")) {
			query.append(UPDATE_DATE + " = ?, ");
		}
		if (!UPDATE_USER.equals("")) {
			query.append(UPDATE_USER + " = ?, ");
		}
		query.delete(query.length() - 2, query.length() - 1);
		query.append(getConditionForKey(cls));
		return query.toString();
	}
	
	
	/**
	 * 폜SQL擾B<br>
	 * @param cls dtoNX
	 * @return 폜SQL
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String getDeleteQuery(
			Class<?> cls
	) throws NoSuchFieldException, IllegalAccessException {
		StringBuffer query = new StringBuffer();
		query.append("DELETE FROM ");
		query.append(getTable(cls));
		query.append(" ");
		query.append(getConditionForKey(cls));
		return query.toString();
	}
	
	
	/**
	 * L[ɂSQL擾B<br>
	 * @param cls dtoNX
	 * @return L[ɂSQL
	 * @throws IllegalAccessException
	 */
	protected String getConditionForKey(Class<?> cls) throws IllegalAccessException {
		StringBuffer query = new StringBuffer();
		query.append("WHERE ");
		Field[] fields = cls.getFields();
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String name = field.getName();
			if (name.indexOf("KEY_") == 0) {
				query.append(field.get(null));
				query.append(" = ? AND ");
			}
		}
		query.delete(query.length() - 4, query.length());
		query.append(" ");
		return query.toString();
	}
	
	/**
	 * L[ɂSQL擾(ǉp)B<br>
	 * @param cls dtoNX
	 * @return L[ɂSQL
	 * @throws IllegalAccessException
	 */
	protected String getAddConditionForKey(Class<?> cls) throws IllegalAccessException {
		StringBuffer query = new StringBuffer();
		query.append(" AND ");
		Field[] fields = cls.getFields();
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String name = field.getName();
			if (name.indexOf("KEY_") == 0) {
				query.append(field.get(null));
				query.append(" = ? AND ");
			}
		}
		query.delete(query.length() - 4, query.length());
		query.append(" ");
		return query.toString();
	}
	
	/**
	 * L[ɂ\[gSQL擾B<br>
	 * @param cls daoNX
	 * @return L[ɂ\[gSQL
	 * @throws IllegalAccessException
	 */
	protected String getOrderForKey(Class<?> cls) throws IllegalAccessException {
		StringBuffer query = new StringBuffer();
		query.append(getOrderBy());
		Field[] fields = cls.getFields();
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String name = field.getName();
			if (name.indexOf("KEY_") == 0) {
				query.append(field.get(null));
				query.append(", ");
			}
		}
		query.delete(query.length() - 2, query.length());
		query.append(" ");
		return query.toString();
	}
	
	/**
	 * e[u擾B<br>
	 * @param cls daoNX
	 * @return e[u
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 * @throws MospException 
	 * @throws SQLException 
	 */
	protected String getTable(
			Class<?> cls
	) throws NoSuchFieldException, IllegalAccessException {
		Field table = cls.getField("TABLE");
		return (String)table.get(null);
	}
	
	/**
	 * őpSQL擾B<br>
	 * @param sortKey     \[gL[
	 * @param isAscending tO
	 * @return őpSQL
	 */
	protected String getPageStatement(String sortKey, boolean isAscending) {
		StringBuffer query = new StringBuffer();
		query.append(getOrderBy() + sortKey + " ");
		if (!isAscending) {
			query.append(getDesc());
		}
		query.append(getLimit () + "? ");
		query.append(getOffset() + "? ");
		return query.toString();
	}
	
	/**
	 * FOR UPDATE SQL擾B<br>
	 * @return FOR UPDATE 
	 */
	protected String getForUpdate()  {
		return "FOR UPDATE";
	}
	
	/**
	 * ORDER BY SQL擾B<br>
	 * @return ORDER BY 
	 */
	protected String getOrderBy()  {
		return "ORDER BY ";
	}
	
	/**
	 * DESC SQL擾B<br>
	 * @return DESC 
	 */
	protected String getDesc()  {
		return "DESC ";
	}
	
	/**
	 * LIMIT SQL擾B<br>
	 * @return LIMIT 
	 */
	protected String getLimit()  {
		return "LIMIT ";
	}

	/**
	 * OFFSET SQL擾B<br>
	 * @return OFFSET 
	 */
	protected String getOffset()  {
		return "OFFSET ";
	}
	
	/**
	 * ʏ擾B<br>
	 * @param dto Ώdto
	 * @throws SQLException
	 */
	protected void mappingCommonInfo(BaseDto dto) throws SQLException {
		if (!INSERT_DATE.equals("")) {
			Date insertDate = new Date(rs.getTimestamp(INSERT_DATE).getTime());
			dto.setInsertDate(insertDate);
		}
		if (!INSERT_USER.equals("")) {
			dto.setInsertUser(rs.getString(INSERT_USER));
		}
		if (!UPDATE_DATE.equals("")) {
			Date updateDate = new Date(rs.getTimestamp(UPDATE_DATE).getTime());
			dto.setUpdateDate(updateDate);
		}
		if (!UPDATE_USER.equals("")) {
			dto.setUpdateUser(rs.getString(UPDATE_USER));
		}
	}
	
	
	/**
	 * ʏݒB<br>
	 * @param isInsert }tO(trueF}AfalseF})
	 * @throws SQLException
	 */
	protected void setCommonParams(boolean isInsert) throws SQLException {
		Date date = new Date();
		if (isInsert) {
			if (!INSERT_DATE.equals("")) {
				setParam(index++, date);
			}
			if (!INSERT_USER.equals("")) {
				setParam(index++, userId);
			}
		}
		if (!UPDATE_DATE.equals("")) {
			setParam(index++, date);
		}
		if (!UPDATE_USER.equals("")) {
			setParam(index++, userId);
		}
	}
	
	
	/**
	 * }mFB<br>
	 * @param expectedCount z肳}
	 * @throws MospException
	 */
	protected void chkInsert(int expectedCount) throws MospException {
		if (cnt != expectedCount) {
			throw new MospException(MospConst.EX_INSERT_FAILED);
		}
	}
	
	
	/**
	 * XVmFB<br>
	 * @param expectedCount z肳XV
	 * @throws MospException
	 */
	protected void chkUpdate(int expectedCount) throws MospException {
		if (cnt != expectedCount) {
			throw new MospException(MospConst.EX_UPDATE_FAILED);
		}
	}
	
	
	/**
	 * 폜mFB<br>
	 * @param expectedCount z肳폜
	 * @throws MospException
	 */
	protected void chkDelete(int expectedCount) throws MospException {
		if (cnt != expectedCount) {
			throw new MospException(MospConst.EX_DELETE_FAILED);
		}
	}
	
	/**
	 * RDBMSނ擾B<br>
	 * {@link #conn}̏񂩂RDBMS̎ނ肷B<br>
	 * @return RDBMS
	 * @throws MospException 
	 */
	protected int getRdbmsType() throws MospException {
		try {
			String rdbmsName = conn.getMetaData().getDatabaseProductName();
			if (rdbmsName.equals("MySQL")) {
				return MospConst.RDBMS_MYSQL;
			} else if (rdbmsName.equals("PostgreSQL")) {
				return MospConst.RDBMS_PGSQL;
			}
			LogUtility.log(cfg, "", "", "", 5,
					MospConst.LOG_MOSPERR, MospConst.LOG_MSG_3003 + rdbmsName);
			throw new MospException(MospConst.EX_UNKNOWN_RDBMS);
		} catch (SQLException e) {
			throw new MospException(
					MospConst.EX_RUNTIME_ERR, MospUtility.getStackTrace(e));
		}
	}
	
	/**
	 * e[u`擾SQL擾B<br>
	 * RDBMSˑ@\BMySQLx[XƂĂB<br>
	 * @param tableName e[u
	 * @return e[u`擾SQL
	 * @throws SQLException 
	 * @throws MospException 
	 */
	protected String getTableDescriptionQuery(
			String tableName
	) throws MospException {
		StringBuffer sb = new StringBuffer();
		switch(getRdbmsType()) {
			case MospConst.RDBMS_MYSQL:
				sb.append("SHOW FULL COLUMNS FROM ");
				sb.append(tableName);
				break;
			case MospConst.RDBMS_PGSQL:
				sb.append("SELECT ");
				sb.append("pg_attribute.attname as FIELD, ");
				sb.append("pg_type.typname as TYPE, ");
				sb.append("pg_description.description as COMMENT ");
				sb.append("FROM ");
				sb.append("pg_attribute, ");
				sb.append("pg_type, ");
				sb.append("pg_description, ");
				sb.append("pg_stat_all_tables ");
				sb.append("WHERE ");
				sb.append("pg_stat_all_tables.relname = '");
				sb.append(tableName.toLowerCase());
				sb.append("' ");
				sb.append("AND ");
				sb.append("pg_stat_all_tables.relid = pg_description.objoid ");
				sb.append("AND ");
				sb.append("pg_description.objsubid <> 0 ");
				sb.append("AND ");
				sb.append("pg_description.objoid = pg_attribute.attrelid ");
				sb.append("AND ");
				sb.append("pg_description.objsubid = pg_attribute.attnum ");
				sb.append("AND ");
				sb.append("pg_type.oid = pg_attribute.atttypid ");
				sb.append("ORDER BY ");
				sb.append("pg_description.objsubid");
				break;
			default:
		}
		return sb.toString();
	}
	
	/**
	 * }SQL擾B<br>
	 * }R[hxɑ}SQL쐬B<br>
	 * AA}R[hő吔ȏSQL쐬ȂB<br>
	 * @param cls  daoNX
	 * @param size }R[h
	 * @param max  }R[hő吔
	 * @return }SQL
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	protected String getInsertQuery(
			Class<?> cls, int size, int max
	) throws IllegalAccessException, NoSuchFieldException {
		StringBuffer query = new StringBuffer();
		query.append(getInsertQueryBase(cls));
		// p[^
		Field[] fields = getClass().getFields();
		// 1R[hSQL쐬
		StringBuffer sb = new StringBuffer();
		sb.append("(");
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String name = field.getName();
			if (name.indexOf("COL_") == 0) {
				sb.append("?, ");
			}
		}
		sb.append(getCommonParams());
		sb.delete(sb.length() - 2, sb.length());
		sb.append("), ");
		// 쐬(AmaxƂ)
		for (int i = 0; i < size; i++) {
			if (i == max) {
				break;
			}
			query.append(sb);
		}
		query.delete(query.length() - 2, query.length());
		return query.toString();
	}
	
	/**
	 * XVnSQLsB<br>
	 * CfbNX}R[h}ΏیɒBꍇA
	 * }sB<br>
	 * {@link #getInsertQuery(Class)}ƕėpB
	 * ʂ̃f[^}ꍇAptH[}X̌オ߂B<br>
	 * @param cls   dtoNX
	 * @param size  }Ώی
	 * @param max   }R[h(xɑ})
	 * @param idx   CfbNX
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	protected void executeUpdate(
			Class<?> cls, int size, int max, int idx
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// CfbNXۂ̌ɍ킹
		int executeIndex = idx + 1;
		// }R[h}ΏیɒBꍇ
		if (executeIndex % max == 0 || executeIndex == size) {
			executeUpdate(false);
			clearParams();
			index = 1;
			if (size - executeIndex < max && executeIndex != size) {
				releasePreparedStatement();
				prepareStatement(getInsertQuery(cls, size - executeIndex, max));
			}
		} else {
			cnt = 0;
		}
	}
	
}
